﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using  System.IO;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Imaging;
namespace UNIPENviewer
{
   
    public struct DataLayout
    {
        int iX_Dim;
        int iY_Dim;
        int[] iH_Line;
        int[] iV_Line;
        List<UPDataBox> list_DataBox;
        String hierachy;
    }
    /// <summary>
    /// keywords in file
    /// </summary>
    public class KEYWORD
    {
        public List<String> strContent;
        public String keyName;
        public KEYWORD()
        {
            keyName = "";
            strContent = new List<string>();
        }
    };
  
   /// <summary>
    /// UNIPENFile structure
   /// </summary>
    class UNIPENFile
    {
       /* allocated filecontents, for the Unipenfile and each included file */   
        String cur_path;
        String cur_file_open;
        List<String> upIncludeFiles;        
        /* keywords */
        List<KEYWORD> keywords;
    
        /// <summary>
        /// 
        /// </summary>
        public String m_Cur_file_open
        {
            get
            {
                return cur_file_open;
            }
            set
            {
                if (cur_file_open == value)
                    return;
                cur_file_open = value;
            }
        }
        public String m_Cur_path
        {
            get
            {
                return cur_path;
            }
            set
            {
                if (cur_path == value)
                    return;
                cur_path = value;
            }
        }
        public List<String> m_UpIncludePaths
        {
            get
            {
                return upIncludeFiles;
            }
            set
            {
                if (upIncludeFiles == value)
                    return;
                upIncludeFiles = value;
            }
        }
        public List<KEYWORD> m_Keywords
        {
            get
            {
                return keywords;
            }
            set
            {
                if (keywords == value)
                    return;
                keywords = value;
            }
        }
        //----------------------------------------------------------------------------------------------------------------------//
        KEYWORD currentKeyword;
        bool bfirstkey;
             
        public UNIPENFile()
        {
            upIncludeFiles = new List<string>();
            currentKeyword =null;
            bfirstkey = true;
            keywords = new List<KEYWORD>();
           
        }

        public void GetKeywordsOfUNIPENFile(string filename)
        {
            try
            {
                // Create an instance of StreamReader to read from a file.
                // The using statement also closes the StreamReader.
                cur_file_open = filename;
                using (StreamReader sr = new StreamReader(filename))
                {
                    string line;
                    // Read and display lines from the file until the end of 
                    // the file is reached.
                    while ((line = sr.ReadLine()) != null)
                    {
                        if (UpLib.SubStringExist(null, line, "."))
                        {
                            String str = "";
                            if (line.IndexOf(" ") > 0)
                            {
                                str = line.Substring(0, line.IndexOf(" "));
                            }
                            else
                            {
                                str = line;
                            }
                            foreach (String st in UpLib.keyworkNames)
                            {
                                if (str.CompareTo(st) == 0)
                                {

                                    if (currentKeyword==null)
                                    {
                                        KEYWORD kw = new KEYWORD();
                                        kw.keyName = str;
                                        currentKeyword = kw;
                                    }
                                    else
                                    {
                                        keywords.Add(currentKeyword);
                                        KEYWORD kw = new KEYWORD();
                                        kw.keyName = str;
                                        currentKeyword = kw;
                                    }
                                    break;
                                }
                            }
                        }
                        if (currentKeyword != null)
                        {
                            currentKeyword.strContent.Add(line);
                        }
                        
                    }
                   
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }
            
            //read include paths
            foreach (var item in keywords)
            {
                if (item.keyName == UpLib.keyInclude)
                {
                    //get include paths
                    foreach (var s in item.strContent)
                    {
                        String sTemp = "";
                        if (UpLib.SubStringExist(null, s, UpLib.keyInclude))
                        {
                            sTemp = s.Substring(s.IndexOf(UpLib.keyInclude) + UpLib.keyInclude.Length).Trim();
                        }
                        else
                        {
                            sTemp = s.Trim();
                        }
                        upIncludeFiles.Add(sTemp);
                    }
                }
            }
            //read keywords in include files
            foreach (var item in upIncludeFiles)
            {
                String tempString = item.Replace("/", "\\");
                String path = String.Format("{0}\\{1}\\{2}", cur_path, "UnipenData\\include", tempString);
                try
                {
                      // Create an instance of StreamReader to read from a file.
                // The using statement also closes the StreamReader.
                    using (StreamReader sr = new StreamReader(path))
                    {
                        string line;
                        // Read and display lines from the file until the end of 
                        // the file is reached.
                        while ((line = sr.ReadLine()) != null)
                        {
                            if (UpLib.SubStringExist(null, line, "."))
                            {
                                String str = "";
                                if (line.IndexOf(" ") > 0)
                                {
                                    str = line.Substring(0, line.IndexOf(" "));
                                }
                                else
                                {
                                    str = line;
                                }
                                foreach (String st in UpLib.keyworkNames)
                                {
                                    if (str.CompareTo(st) == 0)
                                    {
                                        if (currentKeyword==null)
                                        {
                                            KEYWORD kw = new KEYWORD();
                                            kw.keyName = str;
                                            currentKeyword = kw;
                                        }
                                        else
                                        {
                                            keywords.Add(currentKeyword);
                                            KEYWORD kw = new KEYWORD();
                                            kw.keyName = str;
                                            currentKeyword = kw;
                                        }
                                        break;
                                    }
                                }
                            }
                            if (currentKeyword != null)
                            {
                                currentKeyword.strContent.Add(line);
                            }
                        
                        }
                   
                    }
                }
                catch (Exception)
                {
                    
                    throw;
                }
            }
            
        }
        
        public void GetCurrentCharacters(List<Point> points)
        {
            int index = 0;
            foreach (var item in keywords)
            {
                String st = item.keyName;
                Point p = new Point();
                switch (st)
                {
                    case ".PEN_DOWN":
                        if (index ==74)
                        {
                            foreach (var str in item.strContent)
                            {
                                if (String.IsNullOrEmpty(str) == false)
                                {
                                    if (UpLib.SubStringExist(null, str, ".") == false)
                                    {
                                        List<String> sList = new List<String>();
                                        UpLib.GetWordsFromString(null, str, sList);
                                        p.X = Convert.ToInt32((String)sList.ElementAt(0));
                                        p.Y = Convert.ToInt32(sList.ElementAt(1));
                                        points.Add(p);
                                    }
                                }
                            }
                            
                        }
                        if(index>75)
                            goto exitloop;
                        index++;
                          
                        break;
              
                }
               
            }
        exitloop: ;
        }
    }
}
